//
//  MCTVCPrintViewConfigurator.h
//  MCApplication
//
//  Created by aj on Mon Nov 19 2001.
//  Copyright (c) 2001 __MyCompanyName__. All rights reserved.
//

/*

	Pass this object along to multi nib print controller in an array

	userInfo plist format
	{
		"identifier" = {
			MCTVCPViewClassname = aColumnViewClassname;
			MCTVCPOverrideIdentifier = someMethod;
			
			};
	}


*/

#import <Cocoa/Cocoa.h>

extern NSString	*MCTVCPViewClassname;
extern NSString *MCTVCPOverrideIdentifier; // attribute override

extern NSString *MCTVCPageTitle; // title of the page used by the page model
extern NSString *MCTVCPagePrintDate; // date for the page used by the page model

@class MCTableviewController;
@interface MCTVCPrintViewConfigurator : NSObject {
	
	// outlets
	id	headerTemplate; // should respond to setObjectValue:
	id	headerContainer; // expected to autosize to maximum width
	id	rowTemplate; // view to be duplicated for each column/row
	id	rowContainer; // expected to autosize to maximum width, will contain rowTemplates
	
	id	pagePrintController;
	id	tvc;
	
	
	id	cellController;
	id	rowBinder;
	
	// typically not an outlet
	id	userInfo;
	
	NSMutableArray	*addedHeaderViews;
	NSMutableArray	*addedRowViews;
	
	float	averageHeaderViewWidth;

}


// non-retained because it may be outlet
- (void)setNonRetainedUserInfo:(id)uInfo;
- (id)nonRetainedUserInfo;

- (void)setNonRetainedTVC:(MCTableviewController *)aTVC;
- (MCTableviewController *)nonRetainedTVC;

- (void)setNonRetainedPrintPageController:(id)anCtl;
- (id)nonRetainedPrintPageController;

- (void)configureViews;

- (void)clearAll;
- (void)clearRowBindings;
- (void)clearHeaderContainer;
- (void)clearRowContainer;

- (id)addHeaderForTableColumn:(id)oColumn;
- (id)addRowViewForTableColumn:(id)oColumn referenceHeaderView:(id)aHeaderView;
- (void)addBindingForRowView:(id)aRowView usingTableColumn:(id)tableColumn;



@end

@interface NSObject (MCReplication)
/*------------------------
	replicate
	
	Returns a copy of ourselves, along with our subobjects.
*/
- (id)replicateUsingArchiving;

@end

